package main

/*
 * tcoil wire functions
*/

import (
	"math"
)

// return copper dia in mm given AWG gauge
// found this many places and believe it to be true
func awg_to_wcd(awg float64) (wcd_mm float64) {
	wcd_mm = 0.127 * math.Pow(92, (36 - awg) / 39)
	return
}

// return AWG gauge given copper dia in mm
// reversed version of awg_to_wid()
func wcd_to_awg(wcd_mm float64) (awg float64) {
	awg = 36 - 39 * math.Log(wcd_mm / 0.127) / math.Log(92)
	return
}

// return insulated dia wd_mm given copper dia wcu_mm & build
// data obtained from specs up to 0.5 mm dia, linear above that
// 3rd degree polynomial curve fit by eye
// would be nice to have this a bit more nailed-down and official
// as so much depends on it
func build_dia(wcd_mm float64, build int) (wd_mm float64) {
	// single coat defaults:
	a := 0.072
	b := -0.113
	c := 0.059
	slope := 0.0045
	switch build {
	case 0 :  // bare wire
		return (wcd_mm)
	case 1 :  // single coat fall thru
	case 2 :  // double coat
		a = 0.131
		b = -0.218
		c = 0.1253
		slope = 0.009
	default: error_exit("Build out of range [1:2]")
	}
	dia_lim := 0.5  // do linear above this
	dia := math.Min(wcd_mm, dia_lim)  // poly pegs at limit
	lin := math.Max(0, wcd_mm - dia_lim) * slope  // linear from there
	poly := dia * (a + dia * (b + dia * c))
	wd_mm = (poly + lin) * 2 + wcd_mm
	return
}

// return DC ohms/meter given copper radius in m
func dcr_per_m(wcr_m float64) (float64) {
	area := math.Pi * wcr_m * wcr_m
	return(CU_RHO / area)
}

// return kg/m given copper radius in m
func kg_per_m(wcr_m float64) (float64) {
	area := math.Pi * wcr_m * wcr_m
	return(CU_DENSITY * area)
}

// return skin frequency in Hz given copper radius in m
// freq @ 10% DCR increase like Terman's (200mm / dia)^2
func skin_freq(wcr_m float64) (f_hz float64) {
	f_hz = CU_RHO / (MU0 * math.Pi * 0.4879 * wcr_m * wcr_m)
	return
}

