package main

/*
 * tcoil constants & helper functions
*/

import (
	"math"
)

const (
	VER = 3							// software version
	EPSILON = 1e-15					// calculation precision
	CU_RHO = 1.68e-8				// copper resistivity (ohm*m)
	CU_DENSITY = 8960				// copper density (kg/m^3)
	C = 299792458					// speed of light (m/s)
	MU0 = 4.0e-7 * math.Pi			// vacuum magnetic permeability (H/m)
	E0 = 1 / (MU0 * C * C)			// vacuum electric permttivity (F/m)
	OVERLAP = 1e-6					// loops collision allowance (m)
)

