package main

var help_commands_str = `
Usage: TCOIL_EXE [ command ] [ -flag <option> -flag <option> ... ]

COMMANDS & FLAGS:

  <command> -h                                         Help with individual command flags
  help <-v>                                            Command line help with optional examples

  wire <-awg gauge> <-b build> <-wcd wire Cu dia mm>   Wire specs
  lcf <-l mH> <-c pF> <-f kHz> <-r Ohms>               Given 2 of LCF, solve for the 3rd
  pvc <-i>                                             PVC tubing table w/ inches option

  brooks <*> ...                                       Solve brooks coil
  spiral <*> ...                                       Solve flat spiral
  solenoid <*> ...                                     Solve single layer solenoid
  donut <*> ...                                        Solve multi layer donut
  choke <*> ...                                        Solve multi donut choke
  xfmr <*> ...                                         Solve transformer (given n, n2 turns only)
   
  <-l mH>                                              Solve given L
  <-n turns>                                           Solve given N turns
  <-wl m>                                              Solve given wire length
  
  <-wcd wire Cu dia mm> <-wd wire OD mm>               choke, donut, solenoid, spiral, brooks, xfmr
  <-awg gauge> <-b build> <-file file>                 choke, donut, solenoid, spiral, brooks, xfmr
  <-f khz> <-c pF>                                     choke, donut, solenoid, spiral, brooks
  <-fd form dia mm>                                    choke, donut, solenoid, spiral, xfmr
  <-ow donut width turns>                              choke, donut, xfmr
  <-oo donuts offset mm>                               choke, xfmr
  <-o donuts>                                          choke
  <-wcd2 mm> <-wd2 mm> <-awg2 gauge> <-b2 build>       xfmr
  <-n2 turns> <-fd2 mm> <-ow2 turns>                   xfmr
`
var help_verbose_str = `
NOTES:
- Flags may be entered in any order.
- Flag prefix either "-" or "--" (e.g. -awg=32; --awg=32).
- Flags / values separator either space or "=" (e.g. -n 500; -n=500).
- Linux & Mac terminals require executable files to be prefaced with: "./" e.g. "./tc-xxx".
- Windows terminal may require files to be prefaced with: ".\" e.g. ".\tc-xxx".
- Secondary parameters (e.g. wd2, n2) will default to primary if not specified or zero.

USAGE EXAMPLES:
- List flags for a command (e.g. lcf):
    TCOIL_EXE lcf -h
- Show librarian version & compact help:
    TCOIL_EXE help
- Show librarian version & verbose help:
    TCOIL_EXE help -v
- Calculate LC resonant frequency given L=5mH, C=15pF:
    TCOIL_EXE lcf -l 5 -c 15
- Calculate LC capacitance given L=4mH, freq=500kHz:
    TCOIL_EXE lcf -l 4 -f 500
- Calculate LC inductance given C=20pF, freq=900kHz:
    TCOIL_EXE lcf -c 20 -f 900
- Calculate LC inductance and Q given C=20pF, freq=900kHz, R=25ohms
    TCOIL_EXE lcf -c 20 -f 900 -r 25
- Show PVC table in metric:
    TCOIL_EXE pvc
- Show PVC table in inches:
    TCOIL_EXE pvc -i
- Calculate wire specs given CU dia=0.2mm, build=1 coat:
    TCOIL_EXE wire -wcd 0.2 -b 1
- Calculate wire specs given AWG gauge=32, build=2 coats:
    TCOIL_EXE wire -awg 32 -b 2
- Calculate a single layer solenoid given:
  - total inductance=2mH:
  - wire AWG=32
  - wire build=1
  - form dia=38mm
  - capacitance c=15pF
  - OpenSCAD file="solenoid.scad"
    TCOIL_EXE solenoid -awg 32 -b 1 -fd 38 -c 15 -l 2 -file solenoid
- Calculate a spiral coil given:
  - total inductance=5mH:
  - wire OD=0.225mm
  - wire Cu dia=0.2mm
  - form dia=20mm
  - capacitance c=15pF
  - OpenSCAD file="spiral.scad"
    TCOIL_EXE spiral -wd 0.225 -wcd 0.2 -fd 20 -c 15 -l 5 -file spiral
- Calculate a multi-layer donut given:
  - total turns n=369
  - wire OD=0.225mm
  - wire Cu dia=0.2mm
  - form dia=38mm
  - donut width=20 wires
  - capacitance c=15pF
  - OpenSCAD file="donut.scad"
    TCOIL_EXE donut -wd 0.225 -wcd 0.2 -fd 38 -ow 20 -c 15 -n 369 -file donut
- Calculate a multi-donut choke given:
  - total wire length=44.83m
  - wire OD=0.225mm
  - wire Cu dia=0.2mm
  - form dia=38mm
  - donuts=3
  - donut width=11 wires
  - donut offset=5mm
  - frequency=200kHz
  - OpenSCAD file="choke.scad"
    TCOIL_EXE choke -wd 0.225 -wcd 0.2 -fd 38 -ow 11 -oo 5 -f 200 -o 3 -wl 44.83 -file choke
- Calculate a brooks coil given:
  - total inductance=1mH:
  - wire OD=0.22mm
  - wire Cu dia=0.2mm
  - capacitance c=15pF
  - OpenSCAD file="brooks.scad"
    TCOIL_EXE brooks -wd 0.22 -wcd 0.2 -c 15 -l 1 -file brooks
- Calculate a coaxial 3 layer transformer given:
  - total turns n=75
  - wire OD=0.28mm
  - wire Cu dia=0.25mm
  - form dia=30mm
  - form dia2=32mm
  - donut width=25 wires
  - OpenSCAD file="x_coax.scad"
    TCOIL_EXE xfmr -wd 0.28 -wcd 0.25 -fd 30 -n 75 -fd2 32 -ow 25 -file x_coax
- Calculate a "pancake" transformer given:
  - total turns n=75
  - wire AWG=32
  - wire build=2
  - form dia=30mm
  - donut width=1 wire
  - donut offset=1mm
  - OpenSCAD file="x_pancake.scad"
    TCOIL_EXE xfmr -awg 32 -b 2 -fd 30 -n 75 -ow 1 -oo 1 -file x_pancake
`
