package main

/*
 * tcoil former functions
*/

import (
	"fmt"
)

type pvc_t struct {
	sz	float64
	od 	float64
	id	float64
}

// here in imperial units
var pvc_params = []pvc_t {  
	{0.5, 0.84, 0.622},
	{0.75, 1.05, 0.824},
	{1, 1.315, 1.049},
	{1.25, 1.66, 1.38},
	{1.5, 1.9, 1.61},
	{2, 2.375, 2.067},
	{2.5, 2.875, 2.469},
	{3, 3.5, 3.068},
	{4, 4.5, 4.026},
	{5, 5.563, 5.047},
	{6, 6.625, 6.065},
	{8, 8.625, 7.981},
	{10, 10.75, 10.02},
	{12, 12.75, 11.938},
	{14, 14, 13.124},
	{16, 16, 15},
}

// return PVC tubing table
// -inputs-
// inches=imperial dims
// -outputs-
// table=string
func pvc_table(inches bool) (table string) {
	table = fmt.Sprintf("%6s%10s%10s\n", "size", "od", "id")
	for _, param := range pvc_params {
		sz := param.sz
		od := param.od
		id := param.id
		if !inches {
			od *= 25.4
			id *= 25.4
		}
		table += fmt.Sprintf("%6.5g%10.5g%10.5g\n", sz, od, id)
	}
	return
}
